<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Question extends Model 
{

    protected $table = 'questions';
    public $timestamps = true;
    protected $fillable = array('body', 'level');

    public function chapters()
    {
        return $this->belongsToMany('Chapter', 'chapter_id');
    }

    public function answers()
    {
        return $this->hasMany('Answer', 'answer_id');
    }

    public function quizes()
    {
        return $this->belongsToMany('Quiz', 'quiz_id');
    }

}