<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Chapter extends Model 
{

    protected $table = 'chapter';
    public $timestamps = true;
    protected $fillable = array('name', 'lesson_id');

    public function lesson()
    {
        return $this->belongsTo('Lesson', 'lesson_id');
    }

    public function questions()
    {
        return $this->belongsToMany('Question', 'question_id');
    }

}