<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMAttendanceTable extends Migration {

	public function up()
	{
		Schema::create('m_attendance', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('pernr')->unsigned()->nullable();
			$table->string('personnel_area')->nullable();
			$table->string('personnel_subarea')->nullable();
			$table->integer('org_unit')->unsigned()->nullable();
			$table->date('date')->nullable();
			$table->time('time')->nullable();
			$table->integer('type')->nullable();
			$table->string('description')->nullable();
			$table->integer('is_active')->nullable();
			$table->boolean('is_backlog')->nullable();
			$table->decimal('range')->nullable();
			$table->integer('created_by')->unsigned();
			$table->integer('updated_by')->unsigned();
			$table->string('latitude')->nullable();
			$table->integer('file_id')->unsigned()->nullable();
			$table->string('longitude')->nullable();
			$table->integer('approved')->nullable();
			$table->boolean('in_range')->nullable();
			$table->boolean('is_correction')->nullable();
			$table->integer('last_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('m_attendance');
	}
}