<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->date('start_date');
			$table->date('end_date');
			$table->softDeletes();
			$table->timestamps();
			$table->integer('package_id')->unsigned();
			$table->integer('plan_id')->unsigned();
			$table->double('vet_amount');
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}