<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePricesTable extends Migration {

	public function up()
	{
		Schema::create('prices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('package_id')->unsigned();
			$table->integer('feature_id')->unsigned();
			$table->integer('plan_id')->unsigned();
			$table->double('fixed_price');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('prices');
	}
}