<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model 
{

    protected $table = 'services';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description');

    public function payment()
    {
        return $this->hasMany('\Payment');
    }

    public function orders()
    {
        return $this->belongsToMany('\Order', 'order_id');
    }

    public function subscriptions()
    {
        return $this->hasMany('\Subscription');
    }

}