<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PostTag extends Eloquent {

	protected $table = 'post_tag';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function post()
	{
		return $this->belongsTo('App\Models\Post', 'post_id');
	}

	public function tag()
	{
		return $this->belongsTo('App\Models\Tag', 'tag_id');
	}

}