<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username')->unique();
			$table->string('password');
			$table->string('email')->unique()->nullable();
			$table->string('fullname')->nullable();
			$table->string('about')->nullable();
			$table->string('pic')->nullable();
			$table->enum('level', array('AUTHOR', 'EDITOR', 'REDAKSI', 'ADMINISTRATOR'))->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}