<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostActivityTable extends Migration {

	public function up()
	{
		Schema::create('post_activity', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('users_id')->unsigned();
			$table->integer('post_id')->unsigned();
			$table->text('data_old')->nullable();
			$table->text('data_new')->nullable();
			$table->enum('status', array('ACTIVE', 'DRAFT'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('post_activity');
	}
}