<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id', true)->primary();
			$table->integer('user_id')->unsigned();
			$table->date('date');
			$table->double('price');
			$table->longText('remark');
			$table->tinyInteger('order_status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}