<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePromotionsTable extends Migration {

	public function up()
	{
		Schema::create('promotions', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('title')->nullable();
			$table->integer('amount')->unsigned()->nullable();
			$table->smallInteger('amount_percent')->unsigned()->nullable()->index();
			$table->integer('max_amount')->unsigned()->nullable();
			$table->text('description')->nullable();
			$table->smallInteger('discount_type')->unsigned()->nullable();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('promotions');
	}
}