<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsFeedsTable extends Migration {

	public function up()
	{
		Schema::create('news_feeds', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('name')->nullable();
			$table->string('job_title')->nullable();
			$table->text('message')->nullable();
			$table->integer('user_id')->unsigned()->index();
			$table->boolean('is_save')->default(false);
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('news_feeds');
	}
}