<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('phone', 64)->unique()->nullable();
			$table->string('email')->unique()->nullable();
			$table->string('name')->nullable();
			$table->date('dob')->nullable();
			$table->integer('lead_id')->unsigned()->nullable()->index();
			$table->smallInteger('weight')->nullable();
			$table->smallInteger('target_weight')->nullable();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}