<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBatchMenusTable extends Migration {

	public function up()
	{
		Schema::create('batch_menus', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->date('date')->nullable();
			$table->text('title')->nullable();
			$table->string('image_url')->nullable();
			$table->text('description')->nullable();
			$table->integer('batch_id')->unsigned()->nullable()->index();
			$table->integer('category_id')->unsigned()->nullable()->index();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('batch_menus');
	}
}