<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCaseNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('case_notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->text('title');
			$table->text('message');
			$table->enum('delivery_method', array('sms', 'email', 'notify'));
			$table->string('recipient');
			$table->timestamp('sent_at');
			$table->bigInteger('case_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('case_notifications');
	}
}