<?php

namespace App/CaseDeadline;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CaseDeadline extends Model 
{

    protected $table = 'case_deadlines';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description', 'notes', 'deadline_date', 'status_id');

    public function status()
    {
        return $this->hasMany('Status');
    }

    public function case()
    {
        return $this->hasMany('Case', 'case_id');
    }

}