<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductImagesTable extends Migration {

	public function up()
	{
		Schema::create('product_images', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id');
			$table->string('image_path', 255);
			$table->string('image_alt', 255);
			$table->boolean('is_main');
			$table->boolean('is_small');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_images');
	}
}