<?php

namespace App/coreproduct;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Coreproduct extends Model 
{

    protected $table = 'core_products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function producttype()
    {
        return $this->belongsTo('Producttype', 'type_id');
    }

    public function stocks()
    {
        return $this->hasOne('Productstock', 'product_id', 'id');
    }

    public function description()
    {
        return $this->hasOne('Productdetail', 'product_id', 'id');
    }

    public function images()
    {
        return $this->hasMany('Productimage', 'product_id', 'id');
    }

    public function barcode()
    {
        return $this->hasMany('Productbarcode', 'product_id', 'id');
    }

    public function brand()
    {
        return $this->hasOne('Brand', 'id', 'brand_id');
    }

    public function price()
    {
        return $this->hasOne('Productprice', 'product_id', 'id');
    }

}