<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('legal_cases', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mr_info', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_case_clients', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_case_agent', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mr_participants', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mr_financial', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mr_compliance', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mr_special_condition', function(Blueprint $table) {
			$table->foreign('legal_case_id')->references('id')->on('legal_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mr_compliance_employee', function(Blueprint $table) {
			$table->foreign('mlr_compliance_id')->references('id')->on('mr_compliance')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('legal_cases', function(Blueprint $table) {
			$table->dropForeign('legal_cases_parent_id_foreign');
		});
		Schema::table('mr_info', function(Blueprint $table) {
			$table->dropForeign('mr_info_legal_case_id_foreign');
		});
		Schema::table('legal_case_clients', function(Blueprint $table) {
			$table->dropForeign('legal_case_clients_legal_case_id_foreign');
		});
		Schema::table('legal_case_agent', function(Blueprint $table) {
			$table->dropForeign('legal_case_agent_legal_case_id_foreign');
		});
		Schema::table('mr_participants', function(Blueprint $table) {
			$table->dropForeign('mr_participants_legal_case_id_foreign');
		});
		Schema::table('mr_financial', function(Blueprint $table) {
			$table->dropForeign('mr_financial_legal_case_id_foreign');
		});
		Schema::table('mr_compliance', function(Blueprint $table) {
			$table->dropForeign('mr_compliance_legal_case_id_foreign');
		});
		Schema::table('mr_special_condition', function(Blueprint $table) {
			$table->dropForeign('mr_special_condition_legal_case_id_foreign');
		});
		Schema::table('mr_compliance_employee', function(Blueprint $table) {
			$table->dropForeign('mr_compliance_employee_mlr_compliance_id_foreign');
		});
	}
}