<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalCasesTable extends Migration {

	public function up()
	{
		Schema::create('legal_cases', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('parent_id')->unsigned()->default('0');
			$table->enum('case_type', array('mr', 'conveyancing', 'caretaker', 'letting_agent', 'occupation_authority'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('legal_cases');
	}
}