<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LegalCase extends Model 
{

    protected $table = 'legal_cases';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function MLRInfo()
    {
        return $this->hasOne('MRInfo');
    }

    public function client()
    {
        return $this->hasMany('LegalCaseClient');
    }

    public function agent()
    {
        return $this->hasOne('LegalCaseAgent');
    }

    public function participant()
    {
        return $this->hasMany('MRParticipant');
    }

    public function financial()
    {
        return $this->hasOne('MRFinancial');
    }

    public function compliance()
    {
        return $this->hasOne('MRCompliance');
    }

    public function specialCondition()
    {
        return $this->hasMany('MRSpecialCondition');
    }

}