<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('subcategories', function(Blueprint $table) {
			$table->foreign('main_category_id')->references('id')->on('main_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tourist_places', function(Blueprint $table) {
			$table->foreign('subcategory_id')->references('id')->on('subcategories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tourist_places', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('subcategory_id')->references('id')->on('subcategories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('providers', function(Blueprint $table) {
			$table->foreign('main_category_id')->references('id')->on('main_categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('providers', function(Blueprint $table) {
			$table->foreign('subcategory_id')->references('id')->on('subcategories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('providers', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('complaints', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('complaints', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('complaint_images', function(Blueprint $table) {
			$table->foreign('complaint_id')->references('id')->on('complaints')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plans', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('providers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('provider_languages', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('providers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('provider_languages', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('provider_timings', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('providers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('provider_works', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('providers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('providers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('complaint_replys', function(Blueprint $table) {
			$table->foreign('complaint_id')->references('id')->on('complaints')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('subcategories', function(Blueprint $table) {
			$table->dropForeign('subcategories_main_category_id_foreign');
		});
		Schema::table('tourist_places', function(Blueprint $table) {
			$table->dropForeign('tourist_places_subcategory_id_foreign');
		});
		Schema::table('tourist_places', function(Blueprint $table) {
			$table->dropForeign('tourist_places_city_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_city_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_subcategory_id_foreign');
		});
		Schema::table('providers', function(Blueprint $table) {
			$table->dropForeign('providers_main_category_id_foreign');
		});
		Schema::table('providers', function(Blueprint $table) {
			$table->dropForeign('providers_subcategory_id_foreign');
		});
		Schema::table('providers', function(Blueprint $table) {
			$table->dropForeign('providers_city_id_foreign');
		});
		Schema::table('complaints', function(Blueprint $table) {
			$table->dropForeign('complaints_order_id_foreign');
		});
		Schema::table('complaints', function(Blueprint $table) {
			$table->dropForeign('complaints_user_id_foreign');
		});
		Schema::table('complaint_images', function(Blueprint $table) {
			$table->dropForeign('complaint_images_complaint_id_foreign');
		});
		Schema::table('plans', function(Blueprint $table) {
			$table->dropForeign('plans_provider_id_foreign');
		});
		Schema::table('provider_languages', function(Blueprint $table) {
			$table->dropForeign('provider_languages_provider_id_foreign');
		});
		Schema::table('provider_languages', function(Blueprint $table) {
			$table->dropForeign('provider_languages_language_id_foreign');
		});
		Schema::table('provider_timings', function(Blueprint $table) {
			$table->dropForeign('provider_timings_provider_id_foreign');
		});
		Schema::table('provider_works', function(Blueprint $table) {
			$table->dropForeign('provider_works_provider_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_user_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_order_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_provider_id_foreign');
		});
		Schema::table('complaint_replys', function(Blueprint $table) {
			$table->dropForeign('complaint_replys_complaint_id_foreign');
		});
	}
}