<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Entry extends Model 
{

    protected $table = 'entries';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $hidden = array('user_id', 'campaign_id', 'destination_id', 'activated', 'timestamps');

    public function campaign()
    {
        return $this->belongsTo('Campaign');
    }

    public function destination()
    {
        return $this->belongsTo('Destination');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function aids()
    {
        return $this->hasMany('Aid');
    }

}