<?php

namespace products;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Products extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function categories()
	{
		return $this->hasMany('productCategories\ProductCategories', 'product_id');
	}

	public function attribute_set()
	{
		return $this->belongsTo('attributeSets\AttributeSets', 'attribute_set_id');
	}

	public function product_images()
	{
		return $this->hasMany('productImages\ProductImages', 'product_id');
	}

}