<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 191);
			$table->string('user_name', 191);
			$table->string('email', 191);
			$table->string('phone', 191);
			$table->integer('clinic_id');
			$table->string('password', 191);
			$table->boolean('active');
			$table->enum('job', array('doctor', 'sec', 'nurse'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}