<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRepositoriesTable extends Migration {

	public function up()
	{
		Schema::create('repositories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('url', 200);
			$table->string('username', 15);
			$table->string('password', 25);
			$table->integer('project_id')->unsigned();
			$table->string('type');
		});
	}

	public function down()
	{
		Schema::drop('repositories');
	}
}