<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function UserProjects()
	{
		return $this->hasMany('Projects', 'user_id');
	}

	public function Role()
	{
		return $this->belongsTo('Roles', 'user_id');
	}

}