<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Attachments extends Eloquent {

	protected $table = 'attachments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Tasks()
	{
		return $this->belongsTo('Tasks', 'task_id');
	}

	public function UploadedBy()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}