<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdsPriceTable extends Migration {

	public function up()
	{
		Schema::create('ads_price', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('experiment_id')->unsigned();
			$table->integer('slot')->default('0');
			$table->integer('collaboration')->default('0');
			$table->integer('title_length')->default('0');
			$table->integer('description_length')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('ads_price');
	}
}