<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCurrencyTable extends Migration {

	public function up()
	{
		Schema::create('currency', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('currency', 300);
			$table->string('currency_icon');
			$table->integer('user_id');
			$table->enum('flag_activity', array('active', 'not_active'));
		});
	}

	public function down()
	{
		Schema::drop('currency');
	}
}