<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('salon_id')->references('id')->on('salons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('salon_id')->references('id')->on('salons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->foreign('salon_id')->references('id')->on('salons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package_services', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('salon_id')->references('id')->on('salons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('salon_id')->references('id')->on('salons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('salon_contract', function(Blueprint $table) {
			$table->foreign('salon_id')->references('id')->on('salons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('salon_contract', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('salon_id')->references('id')->on('salons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_salon_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_salon_id_foreign');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->dropForeign('packages_salon_id_foreign');
		});
		Schema::table('package_services', function(Blueprint $table) {
			$table->dropForeign('package_services_package_id_foreign');
		});
		Schema::table('package_services', function(Blueprint $table) {
			$table->dropForeign('package_services_service_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_salon_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_created_by_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_salon_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_customer_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
		Schema::table('salon_contract', function(Blueprint $table) {
			$table->dropForeign('salon_contract_salon_id_foreign');
		});
		Schema::table('salon_contract', function(Blueprint $table) {
			$table->dropForeign('salon_contract_user_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_user_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_salon_id_foreign');
		});
	}
}