<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Venue extends Model 
{

    protected $table = 'venue';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description');
    protected $visible = array('name', 'description');

    public function has_user()
    {
        return $this->belongsToMany('User');
    }

    public function has_event()
    {
        return $this->hasMany('Event');
    }

}