<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->string('patient_name');
			$table->string('patient_phone');
			$table->string('patient_age');
			$table->bigInteger('blood_type_id')->unsigned();
			$table->string('bags_num');
			$table->string('hospital_name');
			$table->string('hospital_address');
			$table->decimal('latitude', 10,2);
			$table->decimal('longitude', 10,2);
			$table->bigInteger('city_id')->unsigned();
			$table->longText('notes');
			$table->bigInteger('client_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}