<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionEvaluationSurveysTable extends Migration {

	public function up()
	{
		Schema::create('question_evaluation_surveys', function(Blueprint $table) {
			$table->string('company_id', 7)->primary();
			$table->integer('schedule_id')->primary();
			$table->string('question_code', 20)->primary();
			$table->tinyInteger('aggregated_unit_classify')->primary();
			$table->string('aggregated_unit_name', 200)->primary();
			$table->string('question_subclass_code', 20);
			$table->string('evaluation_subclass_code', 20);
			$table->float('score', 5,2)->nullable();
			$table->float('average_point', 5,2)->nullable();
			$table->integer('count_five_point_answer')->nullable();
			$table->integer('count_four_point_answer')->nullable();
			$table->integer('count_three_point_answer')->nullable();
			$table->integer('count_two_point_answer')->nullable();
			$table->integer('count_one_point_answer')->nullable();
			$table->float('rate_five_point_answer', 5,2)->nullable();
			$table->float('rate_four_point_answer', 5,2)->nullable();
			$table->float('rate_three_point_answer', 5,2)->nullable();
			$table->float('rate_two_point_answer', 5,2)->nullable();
			$table->float('rate_one_point_answer', 5,2)->nullable();
			$table->timestamps();
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('question_evaluation_surveys');
	}
}