<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImprovementActivitiesTable extends Migration {

	public function up()
	{
		Schema::create('improvement_activities', function(Blueprint $table) {
			$table->string('company_id', 7)->primary();
			$table->integer('schedule_number')->primary();
			$table->tinyInteger('improvement_activity_status');
			$table->text('before_plus_comment_posi')->nullable();
			$table->text('before_plus_comment_nega')->nullable();
			$table->text('before_minus_comment_posi')->nullable();
			$table->text('before_minus_comment_nega')->nullable();
			$table->text('before_solution_posi')->nullable();
			$table->text('before_solution_nega')->nullable();
			$table->text('after_plus_comment_posi');
			$table->text('after_plus_comment_nega')->nullable();
			$table->text('after_minus_comment_posi')->nullable();
			$table->text('after_minus_comment_nega')->nullable();
			$table->text('after_solution_posi')->nullable();
			$table->text('after_solution_nega')->nullable();
			$table->timestamps();
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('improvement_activities');
	}
}