<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEvaluationSurveysByEvaluationClassTable extends Migration {

	public function up()
	{
		Schema::create('evaluation_surveys_by_evaluation_class', function(Blueprint $table) {
			$table->string('company_id', 7)->primary();
			$table->integer('schedule_number')->primary();
			$table->string('evaluation_class_code', 20)->primary();
			$table->string('evaluation_class_name', 100);
			$table->float('score', 5,2);
			$table->float('average_point', 5,2);
			$table->string('evaluation_rank', 2)->nullable();
			$table->text('evaluation_comment')->nullable();
			$table->text('evaluation_comment_graph')->nullable();
			$table->timestamps();
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('evaluation_surveys_by_evaluation_class');
	}
}