<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyInfosTable extends Migration {

	public function up()
	{
		Schema::create('company_infos', function(Blueprint $table) {
			$table->timestamps();
			$table->string('company_id', 7)->primary();
			$table->smallInteger('year')->primary();
			$table->bigInteger('revenue')->nullable();
			$table->bigInteger('operating_income')->nullable();
			$table->bigInteger('ordinary_income')->nullable();
			$table->bigInteger('cf_operation')->nullable();
			$table->bigInteger('cf_investment')->nullable();
			$table->bigInteger('cf_finance')->nullable();
			$table->bigInteger('cf_free')->nullable();
			$table->string('ceo_name', 80)->nullable();
			$table->text('core_value')->nullable();
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('company_infos');
	}
}