<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDriversTable extends Migration {

	public function up()
	{
		Schema::create('drivers', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name', 100);
			$table->text('profile_photo')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('team_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('drivers');
	}
}