<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Vesting extends Eloquent {

	protected $table = 'vestings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('employee_id', 'start_period', 'date_limit', 'vacations_option_id', 'vacations_enjoyed', '13th_advance', 'justification');

	public function vacation()
	{
		return $this->hasOne('App\Models\Vacation');
	}

	public function vacation_option()
	{
		return $this->hasOne('App\Models\Vacations_option');
	}

}