<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Employee extends Eloquent {

	protected $table = 'employees';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'name', 'registration', 'admission', 'doc', 'timestamps', 'manager_id', 'occupation_id');

	public function manager()
	{
		return $this->hasOne('App\Models\Manager');
	}

	public function occupation()
	{
		return $this->hasOne('App\Models\Occupation');
	}

	public function vesting()
	{
		return $this->hasOne('App\Models\Vesting');
	}

}