<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertiesTable extends Migration {

	public function up()
	{
		Schema::create('properties', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->bigInteger('property_type_id')->unsigned();
			$table->integer('additional_property_type_id')->unsigned();
			$table->boolean('is_rent')->nullable()->default(0);
			$table->boolean('is_sell')->nullable()->default(0);
			$table->double('price', 10,2)->nullable()->default('0');
			$table->integer('currency_id')->unsigned();
			$table->double('size', 8,2)->nullable()->default('0');
			$table->double('land_size', 8,2)->nullable()->default('0');
			$table->integer('beds')->nullable()->default('0');
			$table->integer('bathrooms')->nullable()->default('0');
			$table->string('year_built', 191)->nullable();
			$table->text('address')->nullable();
			$table->integer('country_id')->unsigned();
			$table->string('city', 191)->nullable();
			$table->string('district', 191)->nullable();
			$table->string('region', 191)->nullable();
			$table->string('latitude', 191)->nullable();
			$table->string('longitude', 191)->nullable();
			$table->text('description')->nullable();
			$table->text('neighborhood_description')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('properties');
	}
}