<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSectionsTable extends Migration {

	public function up()
	{
		Schema::create('sections', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('code', 16);
			$table->integer('ordering');
			$table->integer('location_id')->unsigned();
			$table->integer('sublocation_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('sections');
	}
}