<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonScoresTable extends Migration {

	public function up()
	{
		Schema::create('lesson_scores', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('lesson_id')->unsigned();
			$table->json('competencies_results');
			$table->integer('scored_by')->unsigned()->index();
			$table->timestamp('scored_at');
			$table->integer('created_by')->unsigned();
			$table->integer('updated_by')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('lesson_scores');
	}
}