<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id');
			$table->integer('number')->unique();
			$table->integer('order_id')->nullable();
			$table->integer('discount_code_id')->nullable();
			$table->float('total_items_price');
			$table->float('subtotal_price');
			$table->float('total_discounts');
			$table->float('delivery_fee');
			$table->float('total_tax');
			$table->float('total_price');
			$table->enum('status', array('open', 'paid', 'past_due'));
			$table->integer('payment_attempts');
			$table->date('due_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}