<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImagesTable extends Migration {

	public function up()
	{
		Schema::create('images', function(Blueprint $table) {
			$table->increments('id');
			$table->string('filename', 200)->unique();
			$table->integer('filesize');
			$table->integer('width');
			$table->string('type', 200);
			$table->string('height');
			$table->text('variations');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('images');
	}
}