<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFulfillmentsTable extends Migration {

	public function up()
	{
		Schema::create('fulfillments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('service_area_id');
			$table->integer('order_id')->nullable();
			$table->integer('order_item_id')->nullable();
			$table->integer('customer_storable_id');
			$table->date('dropoff_date')->nullable();
			$table->integer('dropoff_address')->nullable();
			$table->integer('dropoff_timeslot')->nullable();
			$table->date('pickup_date')->nullable();
			$table->integer('pickup_address')->nullable();
			$table->integer('pickup_timeslot')->nullable();
			$table->enum('status', array('in_progress', 'completed', 'cancelled'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('fulfillments');
	}
}