<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBinsTable extends Migration {

	public function up()
	{
		Schema::create('bins', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('storable_id');
			$table->integer('customer_id')->nullable();
			$table->string('code', 32);
			$table->datetime('birth_date');
			$table->datetime('death_date')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bins');
	}
}