<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('assignmentID')->references('id')->on('assignments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('assignments', function(Blueprint $table) {
			$table->foreign('attendance_id')->references('id')->on('attendances')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shiftEvents', function(Blueprint $table) {
			$table->foreign('report_id')->references('id')->on('reports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shiftCounts', function(Blueprint $table) {
			$table->foreign('report_id')->references('id')->on('reports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shiftTrainings', function(Blueprint $table) {
			$table->foreign('report_id')->references('id')->on('reports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shiftExtras', function(Blueprint $table) {
			$table->foreign('report_id')->references('id')->on('reports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shiftEquipments', function(Blueprint $table) {
			$table->foreign('report_id')->references('id')->on('reports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_job_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_user_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_assignmentID_foreign');
		});
		Schema::table('assignments', function(Blueprint $table) {
			$table->dropForeign('assignments_attendance_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_user_id_foreign');
		});
		Schema::table('shiftEvents', function(Blueprint $table) {
			$table->dropForeign('shiftEvents_report_id_foreign');
		});
		Schema::table('shiftCounts', function(Blueprint $table) {
			$table->dropForeign('shiftCounts_report_id_foreign');
		});
		Schema::table('shiftTrainings', function(Blueprint $table) {
			$table->dropForeign('shiftTrainings_report_id_foreign');
		});
		Schema::table('shiftExtras', function(Blueprint $table) {
			$table->dropForeign('shiftExtras_report_id_foreign');
		});
		Schema::table('shiftEquipments', function(Blueprint $table) {
			$table->dropForeign('shiftEquipments_report_id_foreign');
		});
	}
}