<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Report extends Model 
{

    protected $table = 'reports';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function events()
    {
        return $this->hasMany('App\ShiftEvents', 'report_id');
    }

    public function extras()
    {
        return $this->hasMany('App\ShiftExtra', 'report_id');
    }

    public function counts()
    {
        return $this->hasMany('App\ShiftCount', 'report_id');
    }

    public function equipments()
    {
        return $this->hasMany('App\ShiftEquipment', 'report_id');
    }

    public function trainings()
    {
        return $this->hasMany('App\ShiftTraining', 'report_id');
    }

}