<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('code')->unique();
			$table->string('icon');
			$table->string('background_color');
			$table->enum('type', array('free', 'paid', 'gift'));
			$table->double('price');
			$table->double('discount');
			$table->integer('status');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}